from typing import List, Optional, Tuple

from axelrod._strategy_utils import detect_cycle

from axelrod.action import Action

from axelrod.player import Player

C, D = Action.C, Action.D

def is_alternator(history: List[Action]) -> bool:
    for i in range(len(history) - 1):
        if history[i] == history[i + 1]:
            return False
    return True

class DefectorHunter(Player):
    """A player who hunts for defectors.

    Names:

    - Defector Hunter: Original name by Karol Langner
    """

    name = "Defector Hunter"
    classifier = {
        "memory_depth": float("inf"),  # Long memory
        "stochastic": False,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def strategy(self, opponent: Player) -> Action:
        """Actual strategy definition that determines player's action."""
        if (
            len(self.history) >= 4
            and len(opponent.history) == opponent.defections
        ):
            return D
        return C